<?php

class SerialNumberValidator extends CValidator
{
	/**
	 * Wagi cyfr
	 * @var array
	 */
	public $weights;

	/**
	 * checksum modulo
	 * @var type
	 */
	public $modulo;

	public $disableChecksum = false;

	protected function validateCs($value, $object, $attribute)
	{
		if (empty($value)) return;

		if (!preg_match('/^[0-9]{' . (count($this->weights)+1) . '}$/', $value))
		{
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute jest nieprawidłowe.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
			return;
		}

		if ($this->disableChecksum)
			return;

		$sum = 0;
		$values = str_split($value);
		foreach ($this->weights as $i => $val)
			$sum += (int)$values[$i] * (int)$val;
		$sum %= $this->modulo;
		$sum %= 10;

		if ($values[count($this->weights)] != $sum)
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute ma niepoprawną sumę kontrolną.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
	}

	protected function validateAttribute($object, $attribute)
	{
		$value = trim($object->$attribute);
		$this->validateCs($value, $object, $attribute);
	}
}
